require("event/handler");
local __EventDispatcher = class.new();

function __EventDispatcher:constructor()
	self.events = {};
end

--[[
	You'll want to bind your EventHandler objects to an event type with this function.
	Place several calls to this in your macro.init() function; one call for each event to handle.

	Example:
		EventDispatcher:bindHandler('keypressed', KeyPressedHandler);
		EventDispatcher:bindHandler('keyreleased', KeyReleasedHandler);
]]
function __EventDispatcher:bindHandler(eventType, handler)
	if( type(handler) ~= "table" ) then
		error("argument 2 needs to be an EventHandler", 2);
	end

	self.events[eventType] = handler;
end

--[[
	Call this once in your macro.event() function.

	Example:
		function macro.event(e, ...)
			EventDispatcher:handle(e, ...);
		end
]]
function __EventDispatcher:handle(eventType, ...)
	if( self.events[eventType] ) then
		local eventHandler = self.events[eventType](...);
		return eventHandler:handle();
	end
end


EventDispatcher = __EventDispatcher();