Grid	=	class.new();

function Grid:constructor(nodes)
	self.nodes	=	nodes or {};
end


function Grid:findNode(node)
	for i,v in pairs(self.nodes) do
		if(v == node ) then
			return i;
		end
	end
end

function Grid:addNode(node)
	if( table.find(self.nodes, node) ) then
		return; -- Don't add if already exists
	end
	-- Find which nodes we would have visibility to, connect them.

	-- TMP
	local function findNodeByPos(x, y)
		for i,v in pairs(self.nodes) do
			if( v.x == x and v.y == y ) then
				return v;
			end

			error("Couldn't find node by pos", 2);
		end
	end
	if( node.x == 4 and node.y == 0 ) then
		node:addConnection(findNodeByPos(2,2), true);
		node:addConnection(findNodeByPos(3,2), true);
		node:addConnection(findNodeByPos(4,3), true);
		node:addConnection(findNodeByPos(5,4), true);
		node:addConnection(findNodeByPos(5,2), true);
		node:addConnection(findNodeByPos(6,2), true);
	end

	if( node.x == 4 and node.y == 6 ) then
		node:addConnection(findNodeByPos(2,5), true);
		node:addConnection(findNodeByPos(6,5), true);
	end

	-- Now insert the node to the grid
	table.insert(self.nodes, node);

	-- Return a copy of it
	return node;
end

function Grid:removeNode(node)
	-- Find any nodes connecting to this node and remove them.
	for i,v in pairs(self.nodes) do
		v:removeConnection(node);
	end

	-- Now remove it from node list
	table.remove(self.nodes, self:findNode(node));
end