Middleman.Host = class.new();

local serviceIp		=	"0.0.0.0"; -- Service any incoming connection on this port
local defaultPort	=	39627;

function Middleman.Host:constructor(port, tcpOrUdp)
	self.socket 	=	network.socket(tcpOrUdp);
	self.port		=	port or 39627;
	self.clients	=	{};

	print("Self.socket:", self.socket);
	print("serviceIp:", serviceIp, "Port:", self.port);

	if( not self.socket:listen(serviceIp, self.port) ) then
		error(sprintf("Unable to open port %d for listening.", self.port), 2);
	end
end

function Middleman.Host:addClient(client)
	table.insert(self.clients, client);
end

function Middleman.Host:removeClient(client)
	local index = table.find(self.clients, client);
	if( index ) then
		table.remove(self.clients, index)
	end
end

function Middleman.Host:hasClient(client)
	return table.find(self.clients, client);
end