--[[
	This is just a base class. You should be creating your own EventHandler
]]
EventHandler = class.new();

--[[
	Each argument to be passed to your EventHandler object will be passed in the constructor.
	Accept them, and copy them to the 'self' table.

	Example:
		function MyEventHandler:constructor(first, second, third)
			self.first = first;
			self.second = second;
			self.third = third;
		end
]]
function EventHandler:constructor()	
end

--[[
	This function is called to actually process the event. Make use of your
	variables that were passed into the constructor up above.

	Your EventHandler object *must* override this function or you will get an error!
]]
function EventHandler:handle()
	error("Attempt to handle an event that does not have a fire() method", 2);
end