local appWin;
local focusWin;

function macro.init()
	appWin = window.getAppHwnd();
	focusWin = appWin;

	print("Go ahead, press buttons!\n\n");
end

function macro.main(dt)
	return true;
end

function macro.event(e, data1, data2, data3)
	focusWin = window.getFocusHwnd();
	appWin = window.getAppHwnd();
	if( focusWin == appWin ) then
		if( e == "keypressed" ) then
			print(data1, "pressed, toggle state:", data2);
		elseif( e == "keyreleased" ) then
			print(data1, "released, toggle state:", data2);
		elseif( e == "mousepressed" ) then
			print(data1, "mouse pressed");
		elseif( e == "mousereleased" ) then
			print(data1, "mouse released");
		elseif( e == "keypressed" ) then
			print("Key " .. data1 .. " pressed");
		elseif( e == "gamepadpressed" ) then
			print("Gamepad " .. data1 .. " btn " .. data2 .. " pressed");
		elseif( e == "gamepadreleased" ) then
			print("Gamepad " .. data1 .. " btn " .. data2 .. " released");
		elseif( e == "gamepadpovchanged" ) then
			if( data2 == JOY_POVCENTERED ) then
				print("Gamepad " .. data1 .. " POV centered");
			else
				print("Gamepad " .. data1 .. " POV changed: " .. data2);
			end
		elseif( e == "gamepadaxischanged" ) then
			print("Gamepad " .. data1 .. " axis " .. data2 .. " changed: " .. data3);
		end
	end

	if( e == "focuschanged" ) then
		print("Focus change:", data1);
	end

	if( e == "consoleresized" ) then
		print("Console resized. Now: ", data1, data2);
	end
end