--  US English keyboard module
--
--  You should not edit this file unless one of the keys does
--  not work for your keyboard.
--
--  You might also want to use this file to lookup virtual key names.
--  VK_<NAME> should be used in MicroMacro's key functions.
--    Ex: keyboardPress(key.VK_SPACE)  will press the space bar.

global = _G;
module(..., package.seeall);


layout = "US English";

VK_BACKSPACE = 8;
VK_TAB = 9;

VK_RETURN = 13;
VK_ENTER = VK_RETURN;

VK_SHIFT = 16;
VK_CONTROL = 17;
VK_ALT = 164;
VK_LALT = VK_ALT;
VK_RALT = 165;
VK_MENU = 18;
VK_PAUSE = 19;
VK_CAPITOL = 20;

VK_ESCAPE = 27;

VK_SPACE = 32;
VK_PAGEUP = 33;
VK_PAGEDOWN = 34;

VK_END = 35;
VK_HOME = 36;
VK_LEFT = 37;
VK_UP = 38;
VK_RIGHT = 39;
VK_DOWN = 40;

VK_PRINT = 42;
VK_SNAPSHOT = 44; -- use this to actually take a screenshot!

VK_INSERT = 45;
VK_DELETE = 46;

VK_0 = 48;
VK_1 = 49;
VK_2 = 50;
VK_3 = 51;
VK_4 = 52;
VK_5 = 53;
VK_6 = 54;
VK_7 = 55;
VK_8 = 56;
VK_9 = 57;

VK_DASH = 189;
VK_PERIOD = 190;
VK_HYPHEN = VK_DASH;
VK_MINUS = VK_DASH;

VK_EQUAL = 187;
VK_PLUS = VK_EQUAL;

VK_A = 65;
VK_B = 66;
VK_C = 67;
VK_D = 68;
VK_E = 69;
VK_F = 70;
VK_G = 71;
VK_H = 72;
VK_I = 73;
VK_J = 74;
VK_K = 75;
VK_L = 76;
VK_M = 77;
VK_N = 78;
VK_O = 79;
VK_P = 80;
VK_Q = 81;
VK_R = 82;
VK_S = 83;
VK_T = 84;
VK_U = 85;
VK_V = 86;
VK_W = 87;
VK_X = 88;
VK_Y = 89;
VK_Z = 90;

VK_NUMPAD0 = 96;
VK_NUMPAD1 = 97;
VK_NUMPAD2 = 98;
VK_NUMPAD3 = 99;
VK_NUMPAD4 = 100;
VK_NUMPAD5 = 101;
VK_NUMPAD6 = 102;
VK_NUMPAD7 = 103;
VK_NUMPAD8 = 104;
VK_NUMPAD9 = 105;
VK_MULTIPLY = 106;
VK_ADD = 107;

VK_SUBTRACT = 109;
VK_DECIMAL = 110;
VK_DIVIDE = 111;
VK_F1 = 112;
VK_F2 = 113;
VK_F3 = 114;
VK_F4 = 115;
VK_F5 = 116;
VK_F6 = 117;
VK_F7 = 118;
VK_F8 = 119;
VK_F9 = 120;
VK_F10 = 121;
VK_F11 = 122;
VK_F12 = 123;

VK_NUMLOCK = 144;
VK_SCROLL = 145;

VK_LSHIFT = 160;
VK_RSHIFT = 161;
VK_LCONTROL = 162;
VK_RCONTROL = 163;

VK_SEMICOLON = 186;
VK_COMMA = 188;
VK_SLASH = 191;
VK_TILDE = 192;
VK_ACCENT = VK_TILDE;

VK_LBRACKET = 216;
VK_RBRACKET = 221;

VK_BACKSLASH = 220;

VK_SINGLEQUOTE = 222;