#ifndef LUAGLUE_H
#define LUAGLUE_H

	// Whether or not to include profiling information for glues
	//#define PROFILE_LGLUES

	extern "C"
	{
		#include <lua.h>
		#include <lauxlib.h>
		#include <lualib.h>
		//#include <lxplib.h>
	}

	#include <string>
	#include "wininclude.h"

	typedef int (*LuaFunction)(lua_State *);

	struct FunctionMap
	{
		char *name;
		LuaFunction func;
	};

	LARGE_INTEGER lua_toint64(lua_State *, int);

	void registerGlues(lua_State *);
	int luaL_typerror (lua_State *, int, const char *); // Removed in 5.2

	int handle_gc(lua_State *);
	int hdc_gc(lua_State *);
	int netcon_gc(lua_State *);
	int audioresource_gc(lua_State *);

	int int64_add(lua_State *);
	int int64_subtract(lua_State *);
	int int64_multiply(lua_State *);
	int int64_divide(lua_State *);
	int int64_eq(lua_State *);
	int int64_lt(lua_State *);
	int int64_gt(lua_State *);

	int mouseSetDelay(lua_State *);
	int mouseMove(lua_State *);
	int mouseSet(lua_State *);
	int mouseLHold(lua_State *);
	int mouseLRelease(lua_State *);
	int mouseLClick(lua_State *);
	int mouseMHold(lua_State *);
	int mouseMRelease(lua_State *);
	int mouseMClick(lua_State *);
	int mouseRHold(lua_State *);
	int mouseRRelease(lua_State *);
	int mouseRClick(lua_State *);
	int mouseWheelMove(lua_State *);
	int mouseGetPos(lua_State *);

	int keyboardSetDelay(lua_State *);
	int keyboardHold(lua_State *);
	int keyboardRelease(lua_State *);
	int keyboardPress(lua_State *);
	int keyboardState(lua_State *);
	int keyPressed(lua_State *);
	int keyPressedLocal(lua_State *);
	int keyboardType(lua_State *);
	int keyboardBufferClear(lua_State *);
	int getKeyName(lua_State *);

	int attach(lua_State *);
	int attachKeyboard(lua_State *);
	int attachMouse(lua_State *);
	int detach(lua_State *);
	int getAttachedHwnd(lua_State *);
	int openProcess(lua_State *);
	int closeProcess(lua_State *);
	int findProcess(lua_State *);
	int findProcessByExe(lua_State *);
	int findProcessByExeList(lua_State *);
	int findProcessByWindow(lua_State *);
	int getWindowParent(lua_State *);
	int findWindow(lua_State *);
	int findWindowList(lua_State *);
	int getWindowsFromProcess(lua_State *);
	int foregroundWindow(lua_State *);
	int getHwnd(lua_State *);
	int getWindowName(lua_State *);
	int getWindowClassName(lua_State *);
	int setWindowName(lua_State *);
	int windowValid(lua_State *);
	int windowRect(lua_State *);
	int openDC(lua_State *);
	int closeDC(lua_State *);
	int makeColor(lua_State *);
	int getR(lua_State *);
	int getG(lua_State *);
	int getB(lua_State *);
	int getPixel(lua_State *);
	int setPixel(lua_State *);
	int pixelSearch(lua_State *);
	int drawLine(lua_State *);
	int drawRect(lua_State *);
	int saveScreenshot(lua_State *);
	int getClipboard(lua_State *);
	int setClipboard(lua_State *);
	int showWindow(lua_State *);
	int getWindowPos(lua_State *);
	int setWindowPos(lua_State *);
	int findPatternInProcess(lua_State *);
	int getModuleAddress(lua_State *);
	int getModuleFilename(lua_State *);
	int flashWindow(lua_State *);
	int getConsoleAttributes(lua_State *);
	int setConsoleAttributes(lua_State *);

	int getPath(lua_State *);
	int getExecutionPath(lua_State *);
	int setExecutionPath(lua_State *);
	int getFileName(lua_State *);
	int getFilePath(lua_State *);
	int getDirectory(lua_State *);
	int isDirectory(lua_State *);
    int getOpenFileName(lua_State *);
	int getSaveFileName(lua_State *);

	int memoryReadByte(lua_State *);
	int memoryReadUByte(lua_State *);
	int memoryReadShort(lua_State *);
	int memoryReadUShort(lua_State *);
	int memoryReadInt(lua_State *);
	int memoryReadUInt(lua_State *);
	int memoryReadFloat(lua_State *);
	int memoryReadDouble(lua_State *);
	int memoryReadString(lua_State *);
	int memoryReadUString(lua_State *);
	int memoryReadBytePtr(lua_State *);
	int memoryReadUBytePtr(lua_State *);
	int memoryReadShortPtr(lua_State *);
	int memoryReadUShortPtr(lua_State *);
	int memoryReadIntPtr(lua_State *);
	int memoryReadUIntPtr(lua_State *);
	int memoryReadFloatPtr(lua_State *);
	int memoryReadDoublePtr(lua_State *);
	int memoryReadStringPtr(lua_State *);
	int memoryReadUStringPtr(lua_State *);
	int memoryWriteByte(lua_State *);
	int memoryWriteShort(lua_State *);
	int memoryWriteInt(lua_State *);
	int memoryWriteFloat(lua_State *);
	int memoryWriteDouble(lua_State *);
	int memoryWriteString(lua_State *);
	int memoryWriteBytePtr(lua_State *);
	int memoryWriteShortPtr(lua_State *);
	int memoryWriteIntPtr(lua_State *);
	int memoryWriteFloatPtr(lua_State *);
	int memoryWriteDoublePtr(lua_State *);
	int memoryReadBatch(lua_State *);

	int netPushKey(lua_State *);
	int netOpenCon(lua_State *);
	int netListen(lua_State *);
	int netPollListen(lua_State *);
	int netConnect(lua_State *);
	int netConnectStatus(lua_State *);
	int netPollMessages(lua_State *);
	int netGetMessage(lua_State *);
	int netSendMessage(lua_State *);
	int netGetAddress(lua_State *);
	int netCloseCon(lua_State *);

	int newTimer(lua_State *);
	int removeTimer(lua_State *);
	int startTimer(lua_State *);
	int isTriggered(lua_State *);
	int getTime(lua_State *);
	int getTimerFrequency(lua_State *);
	int deltaTime(lua_State *);

	int ipcOpen(lua_State *);
	int ipcClose(lua_State *);
	int ipcSend(lua_State *);

	int soundPlay(lua_State *);
	int soundStop(lua_State *);
	int soundPause(lua_State *);
	int soundLoad(lua_State *);
	int soundSetLooping(lua_State *);
	int soundSetVolume(lua_State *);
	int soundGetState(lua_State *);

	int clearScreen(lua_State *);
	int rest(lua_State *);
	int setPriority(lua_State *);
	int logMessage(lua_State *);
	int logRaw(lua_State *);
	int getVersion(lua_State *);
	int setTextColor(lua_State *);
	int showWarnings(lua_State *);

	int bitAnd(lua_State *);
	int bitOr(lua_State *);
	int bitLShift(lua_State *);
	int bitRShift(lua_State *);

	int sha1_hash(lua_State *);

	int getACP(lua_State *);
	int getOEMCP(lua_State *);
	int getConsoleCP(lua_State *);
	int getConsoleOutputCP(lua_State *);
#endif
