#include "strl.h"
#include <string.h>

size_t strlcpy(char *dest, const char* src, size_t max_len)
{
	size_t src_len = strlen(src);
	size_t cpy_len = 0;

	if( src_len > max_len )
		cpy_len = max_len;
	else
		cpy_len = src_len;

	strncpy(dest, src, cpy_len);
	dest[cpy_len] = 0; // Ensure NULL-terminator

	return strlen(dest);
}

size_t strlcat(char *dest, const char *src, size_t max_len)
{
	size_t start_len = strlen(dest);
	size_t src_len = strlen(src);
	size_t cpy_len = max_len - src_len;

	if( cpy_len > max_len )
		cpy_len = max_len;
	else
		cpy_len = src_len;

	strncat(dest, src, cpy_len);
	dest[start_len + cpy_len] = 0; // Ensure NULL-terminator

	return strlen(dest) - start_len;
}
