#ifndef NETWORKDEVICE_H
#define NETWORKDEVICE_H

	#include <vector>
	#include <string>
	#include <map>
	#include <libnet.h>

	#include "rijndael.h"
	#include "aes.h"

	#define DEFAULT_KEY  "opsE.f4JkLoAQuImodBImZMGp<idg.78aNBdQEffHye32ey"
	#define NETCON_KEYNAME_LEN		64

	typedef std::map<std::string, AES> t_aesMap;

	struct KeyPair
	{
		std::string name;
		std::string key;
	};

	class NetCon;
	class NetworkDevice
	{
		protected:
			std::vector<KeyPair> keyQueue;
			t_aesMap aesMap;
			bool running;
			int driver;

		public:
			NetworkDevice();
			~NetworkDevice();

			int init();
			int cleanup();

			void pushKey(std::string, std::string);
			void registerKeys();
			void flushKeys();

			NetCon openCon(const char *, std::string);
			int listen(const NetCon &);
			NetCon pollListen(const NetCon &);
			int connect(const NetCon &, const char *);
			int connectStatus(const NetCon &);

			int pollMessages(const NetCon &);
			std::string getMessage(const NetCon &);
			int sendMessage(const NetCon &, const char *, int);
			char *getAddress(const NetCon &);
			void closeCon(NetCon &);
	};

	class NetCon
	{
		public:
			NET_CONN *conn;
			char keyname[NETCON_KEYNAME_LEN];

			void setkeyname(const char *);
	};

#endif
