#include "logger.h"

#include <time.h>
#include <string.h>

CLogger *CLogger::pinstance = 0;
CLogger *CLogger::instance()
{
	if( pinstance == 0 )
		pinstance = new CLogger;

	return pinstance;
}

CLogger::CLogger()
{

}

CLogger::~CLogger()
{
	if( outfile.is_open() )
	{
		add("Logging finished. Cleaning up.");
		outfile.close();
	}
}

/* Opens the file for logging with given name.
   Returns zero on error, nonzero on success */
int CLogger::open(const char *filename)
{
	if( outfile.is_open() )
		outfile.close();

	outfile.open(filename, std::ios::out);
	if( outfile.is_open() )
	{
		time_t rawtime;
		struct tm * timeinfo;
		time( &rawtime );
		timeinfo = localtime ( &rawtime );
		char szTime[256];
		//strlcpy(szTime, asctime(timeinfo), 255);
		strftime(szTime, sizeof(szTime) - 1, "%Y-%m-%d %H:%M:%S", timeinfo);

		outfile.flush();
		return true;
	}

	return false;
}

/* Close the currently open file */
void CLogger::close()
{
	if( outfile.is_open() )
		outfile.close();
}

/* Write formatted output to the file. add() prepends
   output with the date and time, and appends a trailing newline (\n) */
void CLogger::add(const char *fmt, ...)
{
	if( !outfile.is_open() )
		return;

	if( fmt == NULL )
		return;

	time_t rawtime;
	struct tm * timeinfo;
	time( &rawtime );
	timeinfo = localtime ( &rawtime );
	char szTime[256];
//	strcpy(szTime, asctime(timeinfo));
//	szTime[255] = 0;
	strftime(szTime, 255, "%Y-%m-%d %H:%M:%S", timeinfo);
	outfile << (char*)&szTime << " : ";

	va_list va_alist;
	char logbuf[1024] = {0};
	va_start(va_alist, fmt);
	_vsnprintf(logbuf + strlen(logbuf), sizeof(logbuf) - strlen(logbuf),
	fmt, va_alist);
	va_end(va_alist);

	outfile << logbuf << std::endl;
	outfile.flush();
}

/* Write unformatted output to the file. add_raw() does not prepend
   output with the date and time, and does not append a trailing
   newline (\n) */
void CLogger::add_raw(const char *outstr)
{
	if( !outfile.is_open() )
		return;

	if( outstr == NULL )
		return;

	outfile << outstr;
	outfile.flush();
}
