#ifndef KEYBOARDDEVICE_H
#define KEYBOARDDEVICE_H

	#include <string>

	#include "wininclude.h"
	#include "misc.h"

	class KeyboardDevice
	{
		protected:
			unsigned int delay;
			HWND attachedHwnd;
			bool wineMode;

		public:
			KeyboardDevice();
			HWND getAttachedHwnd();
			void setAttachedInput(HWND);
			void setDelay(unsigned int);

			bool keyIsExtended(unsigned int);

			void keyHold(unsigned int, unsigned int = 0);
			void keyRelease(unsigned int, unsigned int = 0);
			void keyPress(unsigned int, unsigned int = 0);

			bool keyPressed(unsigned int);
			bool keyPressedLocal(unsigned int);
			bool keyPressedConsole(unsigned int);

			void type(std::string);

			void clearBuffer();

			std::string getKeyName(unsigned int key);

			void setWineMode(bool);
	};

#endif
