#include "timer.h"

LARGE_INTEGER timer::frequency;


Timer::Timer()
{
	startTime = getNow();
	triggerTime = 0.0f;
}

Timer::Timer(double t)
{
	startTime = getNow();
	triggerTime = t;
}

void Timer::start(double t)
{
	startTime = getNow();
	triggerTime = t;
}

bool Timer::triggered()
{
	double deltaTime = getTimeElapsed(startTime);
	if( deltaTime >= triggerTime )
		return true;
	else
		return false;
}



TimeType getNow()
{
	TimeType now;
	QueryPerformanceFrequency(&timer::frequency);
	QueryPerformanceCounter(&now);

	return now;
}

TimeType getTimerFrequency()
{
	return timer::frequency;
}

double deltaTime(TimeType t2, TimeType t1)
{
	// Returns the number of seconds elapsed since t1 till t2.
	TimeType diff;

	diff.QuadPart = t2.QuadPart - t1.QuadPart;
	double fdiff = ((double)diff.QuadPart / timer::frequency.QuadPart) * 1000;
	return fdiff;
}

double getTimeElapsed(TimeType start)
{
	TimeType then = start;
	TimeType now = getNow();
	TimeType diff;

	diff.QuadPart = now.QuadPart - then.QuadPart;
	double deltaTime =
	((double)diff.QuadPart / timer::frequency.QuadPart)* 1000;
	return deltaTime;
}
