#ifndef MISC_H
#define MISC_H

	#ifndef VER_SUITE_WH_SERVER
		#define VER_SUITE_WH_SERVER		0x00008000
	#endif

	#define RS_LETTERS		0x00000001
	#define RS_NUMBERS		0x00000002
	#define RS_SPECIAL		0x00000004
	#define RS_ALL			RS_LETTERS | RS_NUMBERS | RS_SPECIAL

	// Comment out if you don't want color
	#define USE_COLOR   true

	#include <vector>

	#include "wininclude.h"

	extern "C"
	{
		#include <lua.h>
		#include <lauxlib.h>
		#include <lualib.h>
		//#include <lxplib.h>
	}

	#include <string>

	typedef struct cli_options CLI_OPTIONS;
	typedef struct config_options CONFIG_OPTIONS;

	/* DEPRECATED
	struct EnumHwndPair
	{
		HWND hwnd;
		DWORD process;
	};*/

	struct cli_options
	{
		bool enableLogging;
		bool wineMode;
		bool scriptSet;
		std::string scriptName;
		std::vector<std::string> args;
	};

	struct config_options
	{
		std::string language;
		std::string keyboard;
		int windowWidth;
		int windowHeight;
		bool flashOnError;
		bool allowSystemCommands;
		bool useStealth;
		bool enableSound;
	};

	std::string sztolower(std::string);
	std::string sztoupper(std::string);
	void cstrtolower(char *, const char *, size_t = 0);
	void cstrtoupper(const char *, char *, size_t = 0);

	void color_printf(int color, const char *fmt, ...);
	void setColor(unsigned short int, unsigned short int = 0);
	int cocoAvailable(lua_State *);
	HWND getAppHwnd();
	int wildfind(const std::string &, const std::string &);
	std::string getProcessorType();
	std::string getOsName();
	void clearCliScreen();
	std::string getSystemError(int);
	std::string narrowString(std::wstring);

	std::string randomString(unsigned int, unsigned int);

	typedef void (WINAPI *FUNC_GETNATIVESYSTEMINFO)(LPSYSTEM_INFO);

	void rot13(char *);

	void initCliOptions(CLI_OPTIONS *);
	void initConfigOptions(CONFIG_OPTIONS *);
	void handleCommandLineArguments(unsigned int, char **, CLI_OPTIONS *);

	DWORD getUserPriv();
	std::string getPrivName(DWORD);
#endif
