#include "filesystemdevice.h"
#include "filesystem.h"
#include <sys/stat.h>
#include "misc.h"
#include "strl.h"

FilesystemDevice::FilesystemDevice()
{
	executionPath = "";
}

std::string FilesystemDevice::getPath()
{
	return fixSlashes(getAppPath(), SLASHES_TO_STANDARD);
}

std::string FilesystemDevice::getExecutionPath()
{
	return fixSlashes(executionPath, SLASHES_TO_STANDARD);
}

void FilesystemDevice::setExecutionPath(std::string np)
{
	executionPath = np;
}

std::string FilesystemDevice::getFileName(std::string fullpath)
{
	return ::getFileName(fullpath);
}

std::string FilesystemDevice::getFilePath(std::string fullpath)
{
	return ::getFilePath(fullpath);
}

void FilesystemDevice::getDirectory(std::string path,
	std::vector<std::string> &files, std::string ext)
{
	::getDirectory(path, files, ext);
}

int FilesystemDevice::isDirectory(std::string path)
{
	struct stat dstat;
	/*
	char pEnd = path.at(path.size() - 1);
	if( pEnd != '\\' && pEnd != '/' )
		path.push_back('\\');
	*/

	/*int success = */stat(path.c_str(), &dstat);

	if( S_ISDIR(dstat.st_mode) )
		return true;
	else
		return false;
}

std::string FilesystemDevice::getOpenFileName(std::string defaultName, std::string filter)
{
    char cwdBuffer[MAX_PATH+1];
    char fileBuffer[MAX_PATH+1];
	char pathBuffer[MAX_PATH+1];

	// Make sure that we convert slash(/) to backslashes(\)
	defaultName = fixSlashes(defaultName, SLASHES_TO_WINDOWS);

	// Now we can copy it to its proper buffer
    strlcpy((char*)&fileBuffer, ::getFileName(defaultName).c_str(), MAX_PATH);
	strlcpy((char*)&pathBuffer, fixSlashes(::getFilePath(defaultName, true), SLASHES_TO_WINDOWS).c_str(), MAX_PATH);

    OPENFILENAME ofn;
    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = getAppHwnd();
    ofn.hInstance = NULL;
    ofn.lpstrFilter = filter.c_str();
    ofn.lpstrCustomFilter = NULL;
    ofn.nMaxCustFilter = 0;
    ofn.nFilterIndex = 1;
    ofn.lpstrFile = (LPSTR)&fileBuffer;
    ofn.nMaxFile = MAX_PATH;
    ofn.lpstrFileTitle = NULL;
    ofn.nMaxFileTitle = 0;
    ofn.lpstrInitialDir = pathBuffer;
    ofn.lpstrTitle = NULL;
    ofn.Flags = (DWORD)(OFN_ENABLESIZING);
    ofn.nFileOffset = (WORD)NULL;
    ofn.nFileExtension = (WORD)NULL;
    ofn.lpstrDefExt = NULL;
    ofn.lCustData = (WORD)NULL;
    ofn.lpfnHook = NULL;
    ofn.lpTemplateName = NULL;
    ofn.pvReserved = NULL;
    ofn.dwReserved = (WORD)NULL;
    ofn.FlagsEx = (DWORD)0;

    /* NOTE: The dialog will modify the CWD, so we must restore it when done. */
    GetCurrentDirectory(MAX_PATH,(LPTSTR)&cwdBuffer);

    int success = GetOpenFileName(&ofn);
    if( success )
    { // User clicked OK

    }
    else
    { // User clicked cancel
		SetCurrentDirectory((LPCTSTR)&cwdBuffer);
		return "";
    }

    SetCurrentDirectory((LPCTSTR)&cwdBuffer);
    return (std::string)ofn.lpstrFile;
}

std::string FilesystemDevice::getSaveFileName(std::string defaultName, std::string filter)
{
    char cwdBuffer[MAX_PATH+1];
    char fileBuffer[MAX_PATH+1];
	char pathBuffer[MAX_PATH+1];

	// Make sure that we convert slash(/) to backslashes(\)
	defaultName = fixSlashes(defaultName, SLASHES_TO_WINDOWS);

	// Now we can copy it to its proper buffer
    strlcpy((char*)&fileBuffer, ::getFileName(defaultName).c_str(), MAX_PATH);
	strlcpy((char*)&pathBuffer, fixSlashes(::getFilePath(defaultName, true), SLASHES_TO_WINDOWS).c_str(), MAX_PATH);


    OPENFILENAME ofn;
    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = getAppHwnd();
    ofn.hInstance = NULL;
    ofn.lpstrFilter = filter.c_str();
    ofn.lpstrCustomFilter = NULL;
    ofn.nMaxCustFilter = 0;
    ofn.nFilterIndex = 1;
    ofn.lpstrFile = (LPSTR)&fileBuffer;
    ofn.nMaxFile = MAX_PATH;
    ofn.lpstrFileTitle = NULL;
    ofn.nMaxFileTitle = 0;
    ofn.lpstrInitialDir = pathBuffer;
    ofn.lpstrTitle = NULL;
    ofn.Flags = (DWORD)(OFN_ENABLESIZING);
    ofn.nFileOffset = (WORD)NULL;
    ofn.nFileExtension = (WORD)NULL;
    ofn.lpstrDefExt = NULL;
    ofn.lCustData = (WORD)NULL;
    ofn.lpfnHook = NULL;
    ofn.lpTemplateName = NULL;
    ofn.pvReserved = NULL;
    ofn.dwReserved = (WORD)NULL;
    ofn.FlagsEx = (DWORD)0;

    /* NOTE: The dialog will modify the CWD, so we must restore it when done. */
    GetCurrentDirectory(MAX_PATH,(LPTSTR)&cwdBuffer);

    int success = GetSaveFileName(&ofn);
    if( success )
    { // User clicked OK

    }
    else
    { // User clicked cancel
		SetCurrentDirectory((LPCTSTR)&cwdBuffer);
		return "";
    }

    SetCurrentDirectory((LPCTSTR)&cwdBuffer);
    return (std::string)ofn.lpstrFile;
}
