#ifndef FILESYSTEM_H
#define FILESYSTEM_H

	#include <string>
	#include <vector>

	#include "wininclude.h"

	#define SLASHES_TO_STANDARD		0
	#define SLASHES_TO_WINDOWS		1

	std::string getAppPath();
	std::string fixSlashes(std::string, int);
	std::string getFilePath(std::string, bool = false);
	std::string getFileName(std::string);
	std::string fixFileRelatives(std::string);
	void getDirectory(std::string, std::vector<std::string> &, std::string="");

	int fileExists(std::string);
#endif
