#include <stdio.h>
#include <stdlib.h>

#include "audiodevice.h"
#include "error.h"
#include "logger.h"


AudioDevice::AudioDevice()
{
	alutInit(0, NULL);
	ALenum error = alGetError();
	if( error != AL_NO_ERROR )
	{
		char errBuff[1024];
		std::string errstr = errorLookup(error);
		snprintf((char*)&errBuff, 1024, "OpenAL error: alutInit() returned error code \'%s\'",
			errstr.c_str());
		fprintf(stderr, "%s\n", (char*)&errBuff);
		Logger::instance()->add("%s");
	}
}

std::string AudioDevice::errorLookup(ALenum error)
{
	switch(error)
	{
		case AL_INVALID_NAME:
			return "Invalid name";
		break;

		case AL_INVALID_ENUM:
			return "Invalid enum";
		break;

		case AL_INVALID_VALUE:
			return "Invalid value";
		break;

		case AL_INVALID_OPERATION:
			return "Invalid operation";
		break;

		case AL_OUT_OF_MEMORY:
			return "Out of memory";
		break;

		default:
			std::ostringstream ss;
			ss << "Unknown error " << error;
			return ss.str();
		break;
	}
}

AudioDevice::~AudioDevice()
{
	#ifdef	DISPLAY_DEBUG_MESSAGES
	Logger::instance()->add("DEBUG: Calling alutExit()");
	#endif
	alutExit();
	#ifdef	DISPLAY_DEBUG_MESSAGES
	Logger::instance()->add("DEBUG: Audio device deleted.");
	#endif
}
