#ifndef __SETTINGS_H__
#define __SETTINGS_H__

	#include <string>
	#include <map>

	#include "types.h"

	#define CONFIG_VAR_CLIWIDTH			"windowWidth"
	#define CONFIG_VAR_CLIHEIGHT		"windowHeight"
	#define CONFIG_VAR_STEALTH			"useStealth"
	#define CONFIG_VAR_FLASHONERROR		"flashOnError"
	#define CONFIG_VAR_ENABLESOUND	  "enableSound"
	#define CONFIG_VAR_SCRIPTS_DIR		"scriptsDirectory"

	#define CONFIG_MEMORY_READ_STRING_BUFFER_KEY	"memoryReadStringBufferSize"

	typedef std::map<std::string, Multivar> t_settingsmap;

	class Settings
	{
		protected:
			static Settings *pinstance;

			t_settingsmap settingsmap;

			Settings();
			Settings(const Settings &);
			Settings& operator=(const Settings &);

		public:
			void setString(const char *, std::string);
			void setFloat(const char *, double);
			void setBool(const char *, bool);

			std::string getString(const char *);
			double getFloat(const char *);
			bool getBool(const char *);

			static Settings *instance();

			void clearSettings();
	};

#endif
