#ifndef PROCESSDEVICE_H
#define PROCESSDEVICE_H

	#include "wininclude.h"
	#include "types.h"

	#include <string>
	#include <vector>

	// Whether or not to protect the user from opening access to
	// MicroMacro's memory. This is to protect the end users;
	// not restrict them. You can disable this by commenting out
	// the line below and recompiling.
	#define PROCESS_PROTECT_MODE			1

	class ProcessDevice
	{
		protected:
			HWND attachedHwnd;
			bool attached;
			bool procDataCompare(const unsigned char *,
				const unsigned char *, const char *);

		public:
			ProcessDevice();
			~ProcessDevice();

			int attach(HWND);
			int detach();

			int reattach();
			int detach_temp();

			HWND getAttachedHwnd();

			HANDLE openProcess(int);
			void closeProcess(HANDLE &);

			DWORD findProcess(std::string, int &);
			DWORD findProcessByExe(std::string, int &);
			DWORD findProcessByWindow(HWND, int &);

			HWND getWindowParent(HWND);
			HWND findWindow(std::string, std::string, int &);
			void findWindowList(std::string, std::string, std::vector<HWND> &,
				int &);
			HWND foregroundWindow();

			//HWND getHwnd(); // DEPRECATED; moved to ::getAppHwnd() from misc.cpp

			std::string getWindowName(HWND, int &);
			std::string getWindowClassName(HWND, int &);
			void setWindowName(HWND, std::string &, int &);
			int windowValid(HWND);

			RECT windowRect(HWND);

			WinDC openDC(HWND);
			void closeDC(WinDC &);

			int makeColor(unsigned char, unsigned char, unsigned char);
			unsigned char getR(int);
			unsigned char getG(int);
			unsigned char getB(int);
			int getPixel(WinDC *, int, int);
			void setPixel(WinDC *, int, int, int);
			POINT pixelSearch(WinDC *, int, int, int, int, int,
				unsigned char = 0, int = 1);
			void drawLine(HDC, int, int, int, int, int, int);
			void drawRect(HDC, int, int, int, int, int, int);
			void saveScreenshot(HWND, const char *);

			std::string getClipboard();
			void setClipboard(std::string &);

			void showWindow(HWND, int);

			unsigned long findPatternInProcess(HANDLE, unsigned char *, char *,
				unsigned long, unsigned long);

			unsigned long getModuleAddress(DWORD, const char *);

			void flashWindow(HWND, int);
	};

	/* Used in findWindow */
	struct EnumWindowPair
	{
		HWND hwnd;
		std::string windowname;
		std::string classname;
	};

	/* Used in findWindowList */
	struct EnumWindowListPair
	{
		std::vector<HWND> hwndVec;
		std::string windowname;
		std::string classname;
	};

#endif
