#ifndef MOUSEDEVICE_H
#define MOUSEDEVICE_H

	#include "wininclude.h"

	class MouseDevice
	{
		protected:
			unsigned int delay;
			int vMouseX;
			int vMouseY;
			HWND attachedHwnd;
			bool wineMode;

		public:
			MouseDevice();
			HWND getAttachedHwnd();
			void setAttachedInput(HWND);
			void setDelay(unsigned int);

			void move(int, int);
			void set(int, int);

			void leftHold(unsigned int modifier = 0);
			void leftRelease(unsigned int modifier = 0);
			void leftClick(unsigned int modifier = 0);

			void middleHold(unsigned int modifier = 0);
			void middleRelease(unsigned int modifier = 0);
			void middleClick(unsigned int modifier = 0);

			void rightHold(unsigned int modifier = 0);
			void rightRelease(unsigned int modifier = 0);
			void rightClick(unsigned int modifier = 0);

			void wheelMove(int);

			int getX();
			int getY();

			void setWineMode(bool);
	};

#endif
