#ifndef LUAENGINE_H
#define LUAENGINE_H

	extern const char *INTRO_TEXT;
	extern int mainRunning;

	#define DEFAULT_SCRIPTS_DIR "scripts\\"
	#define LIB_DIR			 "lib\\"
	#define PLUGIN_DIR		  "plugins\\"
	#define COMMAND_DIR		 "commands\\"
	#define LOG_FILE			"log.txt"
	#define CONFIG_FILE		 "config.lua"
	#define LIB_FILE			"lib.lua"
	#define NET_FILE			"net.lua"


	extern "C"
	{
		#include <lua.h>
		#include <lauxlib.h>
		#include <lualib.h>
		//#include <lxplib.h>
	}

	#include <string>
	#include <vector>

	#include "misc.h"

	class LuaEngine
	{
		protected:
			lua_State *lstate;
			int keyboardModuleLoaded();
			int registerEncryptionKeys();
			int createEncryptionKeysFile();

			int loadConfigFile(const char *);
			int getConfigInt(const char *, int);
			int getConfigBool(const char *, int);
			std::string getConfigStr(const char *, const char *);

			static void luaEngineHook(lua_State *, lua_Debug *);

			std::string keyboardLayoutName;

			int flashOnError;

		public:
			LuaEngine();
			int init(CLI_OPTIONS * = NULL);
			int reinit(CLI_OPTIONS * = NULL);
			int cleanup();
			int run(const char *);
			int run(std::string, std::vector<std::string> &);
			int checkCommands(std::string &, std::vector<std::string> &);

			lua_State *getLuaState();
	};
#endif
