local global = _G;
local type = type;
local pairs = pairs;
module(...)

function encode(tab)
	if( type(tab) ~= "table" ) then
		return;
	end

	local str = "{";
	local count = 1;
	for i,v in pairs(tab) do
		if( type(v) == "number" or type(v) == "string" or type(v) == "table" ) then
			if( count > 1 ) then
				str = str .. ",";
			end

			if( type(v) == "number" ) then
				str = str .. "\"" .. i .. "\":" .. global.tostring(v);
			elseif( type(v) == "string" ) then
				str = str .. "\"" .. i .. "\":\"" .. v .. "\"";
			elseif( type(v) == "table" ) then
				str = str .. "\"" .. i .. "\":" .. encode(v);
			end

			count = count + 1;
		end
	end
	local str = str .. "}";
	return str;
end

function decode(str)
	if( type(str) ~= "string" ) then
		return;
	end;

	local s,e,subtext = global.string.find(str, "^{(.*)}$", 1, false);
	if( not s ) then
		return; -- not valid JSON
	end

	subtext = subtext .. ","; -- just makes parsing easier.

	local holder = {};
	for i,v in global.string.gmatch(subtext, "\"([A-Za-z0-9_]*)\":({?\"?.*\"?)}?,") do
		global.print("vals: ", i, v);
	end
end