-- MicroMacro main configuration file

------------------------------------------------------
-- Language
------------------------------------------------------
-- Language modules are located in lib/mods/language
-- Typically, you want to use the two letter abbreviation
-- for your language. ie. en for English, es for Spanish
-- or de for German.

	language = "en";


------------------------------------------------------
-- Keyboard
------------------------------------------------------
-- Keyboard layout modules are located in lib/mods/keyboard
-- These may be more specific than language is. That is,
-- en_us (US English keyboard) differentiates from en_uk
-- (British English keyboard).

	keyboard = "en_us";


------------------------------------------------------
-- Module settings
------------------------------------------------------
-- Place any filenames (do not include path or extensions) here
-- that you want to be autoloaded before each script execution.
--
-- These may be Lua or DLL files. Lua files should be placed in
-- the 'lib/mods' directory and contain the .lua extension. Any
-- DLL placed in 'plugins' does not need to be mentioned here.
-- They will be autoloaded as-is. If you must place a DLL in
-- the micromacro root folder (the DLL may require additional
-- dependencies), then you must insert an entry to autoload it
-- here.

	moduleAutoload = {
		"xml",
		"classes",
		"cli",
		"table_addon",
		"math_addon",
		"string_addon",
	};


------------------------------------------------------
-- Output settings
------------------------------------------------------
-- Leave windowWidth and windowHeight as 0 to use system defaults.
-- Width and height should probably not exceed 80. These
-- values are dependant on your operating system's settings.

	windowWidth = 0;
	windowHeight = 0;
	flashOnError = true;

------------------------------------------------------
-- Security settings
------------------------------------------------------
-- If you are worried about scripts potentially opening
-- programs or calling dangerous system commands, set
-- allowSystemCommands to 'false'. This will disable
-- os.execute() and io.popen() commands.
-- Be aware that some scripts may need these functions
-- for valid reasons.

	allowSystemCommands = true;

------------------------------------------------------
-- General options
------------------------------------------------------
-- memoryReadStringBufferSize - The size of the buffer,
-- in bytes, used for reading strings.

	memoryReadStringBufferSize = 128;

-- scriptsDirectory - The default location to look for
-- scripts in. Leave empty to assume default

	scriptsDirectory = "";


------------------------------------------------------
-- Advanced options
------------------------------------------------------
-- useStealth  -  Attempt to hide the process by
--                randomizing the window name. Should
--                be true or false.
--
-- enableSound - You can turn off sound if you chose.
--               Doing so will cause the sound thread
--               To not be created, hence lowering
--               processor usage by a small amount.

	useStealth = false;
	enableSound = true;