#ifndef MESSAGE_H
#define MESSAGE_H

#include <string>

#define P_BIGENDIAN		 1
#define P_LITTLEENDIAN	  0

#define P_TYPE_ERROR		0
#define P_TYPE_STRING	   1
#define P_TYPE_INTEGER	  2
#define P_TYPE_FLOAT		3

class Message
{
	private:
		std::string holder;
		int endianType;

		void convertEndian(void *, void *, long);
		long iFixEndian(long);
		double fFixEndian(double);

	public:
		Message();
		void push_string(char *, unsigned int);
		void push_string(std::string);
		void push_integer(long);
		void push_float(double);

		int get_next_type();
		std::string read_string();
		long read_integer();
		double read_float();

		std::string get_debug_string();

		void set_data(const std::string &);
		void set_data(const char *, unsigned int);

		unsigned int length();
		std::string str();
		const char *c_str();
};

#endif
