#include "audioresource.h"

#include <stdio.h>

AudioResource::AudioResource()
{

}

AudioResource::AudioResource(const char *f)
{
	load(f);
}

AudioResource::~AudioResource()
{
	alDeleteBuffers(1, &buffer);
	alDeleteSources(1, &source);
}

void AudioResource::play()
{
	alSourcePlay(source);
}

void AudioResource::stop()
{
	alSourceStop(source);
}

void AudioResource::pause()
{
	alSourcePause(source);
}

int AudioResource::load(const char *file)
{
	alGetError();
	buffer = alutCreateBufferFromFile(file);
	if( buffer == AL_NONE )
		return false;

	alGenSources(1, &source);
	alSourcei(source, AL_BUFFER, buffer);

	if( alGetError() != AL_NO_ERROR )
		return false;

	return true;
}

ALuint AudioResource::getSource()
{
	return source;
}

int AudioResource::getState()
{
	ALint state;
	alGetSourcei(source, AL_SOURCE_STATE, &state);

	return state;
}

void AudioResource::setLooping(int loop)
{

	if( loop )
		alSourcei(source, AL_LOOPING, AL_TRUE);
	else
		alSourcei(source, AL_LOOPING, AL_FALSE);
}

void AudioResource::setVolume(float volume)
{
	alSourcef(source, AL_GAIN, volume);
}

