if( type(class) ~= "function" ) then
	error("The \'classes\' module needs to be included before the math addon module.", 2);
end

function math.distance(x1, y1, x2, y2)
	if( type(x1) ~= "number" or
		type(y1) ~= "number" or
		type(x2) ~= "number" or
		type(y2) ~= "number" ) then
		error("Error: nil value passed to distance()", 2);
	end

	return math.sqrt( (y2-y1)*(y2-y1) + (x2-x1)*(x2-x1) );
end




-- Vector2d class definition
Vector2d = class();

function Vector2d:constructor(_x, _y)
	self.X = _x or 0;
	self.Y = _y or 0;
end

function Vector2d:set(_x, _y)
	self.X = _x;
	self.Y = _y;
end

-- Vector length/magnitude/norm
function Vector2d:length()
	return math.sqrt(self.X * self.X + self.Y * self.Y);
end

-- Vector addition
function Vector2d:__add(b)
	if( not b:is_a(Vector2d) ) then
		error("Vector addition requires two Vector2d objects.", 2);
	end

	return Vector2d(self.X + b.X, self.Y + b.Y);
end

-- Vector subtraction
function Vector2d:__sub(b)
	if( not b:is_a(Vector2d) ) then
		error("Vector subtraction requires two Vector2d objects.", 2);
	end

	return Vector2d(self.X - b.X, self.Y - b.Y);
end

-- Vector dot product
function Vector2d:__mul(b)
	if( not b:is_a(Vector2d) ) then
		error("Vector dot product requires two Vector2d objects.", 2);
	end

	return Vector2d(self.X * b.X, self.Y * b.Y);
end

-- Vector scalar division
function Vector2d:__div(b)
	if( type(b) ~= "number" ) then
		error("Vector scalar division requires a Vector2d object and a number value.", 2);
	end

	return Vector2d(self.X / b, self.Y / b);
end